#!/bin/bash

set -eux

# Check if at least one input argument is provided
if [ $# -lt 1 ]; then
    echo "Usage: $0 <BUILD_COMMAND>"
    exit 1
fi

# Store the first input argument as BUILD_COMMAND
BUILD_COMMAND=$1

# Check if BUILD_COMMAND is set
if [ -z "$BUILD_COMMAND" ]; then
    echo "BUILD_COMMAND is not set. Please check lib/create-osbuild.sh"
    exit 1
fi

LOCAL_CONTAINER_IMAGE="localhost/builder:latest"
BUILDDIR=_build
EXEC="cd /host; mkdir -p $BUILDDIR; cp -f /usr/bin/osbuild $BUILDDIR/osbuild; chcon system_u:object_r:install_exec_t:s0 $BUILDDIR/osbuild; export PATH=$BUILDDIR:\$PATH; export OSBUILD_BUILDDIR=$BUILDDIR; automotive-image-builder ${BUILD_COMMAND}"

# Run the AIB container with the BUILD_COMMAND
podman run -i -v /dev:/dev -v "$PWD":/host -w /host --rm --privileged $LOCAL_CONTAINER_IMAGE /bin/bash -c "$EXEC"
